model:setName( "Pro_Contrast_option1" )
model:caption( "Pro Contrast (option1)" )

model:addSource("inputImage")
model:addSource("originalImage")
model:addSource("histogram0")
model:addSource("histogram1")
model:addSource("histogram2")
model:addSource("histogram3")
model:addSource("histogram4")
model:addSource("histogram5")
model:addSource("minMaxAverage")

--basis filter added
f3= model:addFilter("ProContrast")
f1= model:addFilter("LscAndSinterFilter")

pc = model:getFilter(f3)

pc:setFloatParameter( "correctColorCast", 0)
pc:setFloatParameter( "correctContrast", 0)
pc:setFloatParameter( "protect_shadows", 0)
pc:setFloatParameter( "protect_hilights", 0)

--lscValues--------------------------------------

lsc = model:getFilter(f1)
lsc:setIntParameter( "sinterStrucLscMode0_", 0  )
lsc:setIntParameter( "sinterStrucLscMode1_" ,0 )
lsc:setIntParameter( "tileSizeLevel0", 3 )
lsc:setIntParameter( "tileSizeLevel1",3 )
lsc:setIntParameter( "selectedChannel0_", 0 )
lsc:setIntParameter( "selectedChannel1_", 0 )
lsc:setFloatParameter( "sigma20", 140 )
lsc:setFloatParameter( "sigma21", 30 )
lsc:setIntParameter("lemmingType0", 0)
lsc:setIntParameter( "lemmingType1",2 )
lsc:setFloatParameter("maxDeriv0", 4)
lsc:setFloatParameter( "maxDeriv1", 7 )
lsc:setFloatParameter( "strength0", 52 )
lsc:setFloatParameter( "strength1", 0 )
lsc:setFloatParameter( "strengthFactor", 100 )
lsc:setFloatParameter( "totalStrength", 0 )
lsc:setFloatParameter( "brightness", 0)
lsc:setFloatParameter( "contrast", 0 )
lsc:setFloatParameter( "saturation", 25)
lsc:setFloatParameter( "csStrength", 0.0 )
lsc:setFloatParameter( "deltaT", 30 )
lsc:setFloatParameter( "numberOfTimesteps", 4)
lsc:setFloatParameter( "modifier_A", 0.75)
lsc:setFloatParameter( "modifier_B", 48)
lsc:setFloatParameter( "modifier_C",3)
lsc:setFloatParameter( "modifier_D", 75)


function pro_contrast_fixcolor(v)
  pc = model:getFilter(f3)
  pc:setFloatParameter( "correctColorCast", v)
end
model:addFloatSlider("pro_contrast_fixcolor", 0,0,1,"pro_contrast_fixcolor", "Correct Color Cast", "")

model:setFloatParameter("pro_contrast_fixcolor",0);

function pro_contrast_fixbrightness(v)
  pc = model:getFilter(f3)
  pc:setFloatParameter( "correctContrast", v)
end
model:addFloatSlider("pro_contrast_fixbrightness", 0,0,1,"pro_contrast_fixbrightness", "Correct Contrast", "")

model:setFloatParameter("pro_contrast_fixbrightness",0);

model:forwardFloatParameter("totalStrength", f1, "totalStrength", 0, 0, 100, "Dynamic Contrast", "" )


-- Protect Hi/Sh
function protect_shadows_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectShadows", v)
  pc = model:getFilter(f3)
  pc:setFloatParameter( "protect_shadows", v)
end 
model:addFloatSlider("protect_shadows", 0,0,1,"protect_shadows_function", "Shadows", "")

function protect_hilights_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectHighlights", v)
  pc = model:getFilter(f3)
  pc:setFloatParameter( "protect_hilights", v)
end
model:addFloatSlider("protect_hilights",0,0,1,"protect_hilights_function", "Highlights", "")
